IF OBJECT_ID('P_EXP_CTB_MOV_AJUSTE_CAIXA') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_AJUSTE_CAIXA
	END
 
GO
 
CREATE PROCEDURE P_EXP_CTB_MOV_AJUSTE_CAIXA( @CD_EMP		INT,
											 @CD_FILIAL	    INT,
											 @DT_INI		DATETIME,
											 @DT_FIM		DATETIME,
											 @FLAG_LIMPAR   INT = 0)		
	

WITH ENCRYPTION AS  

BEGIN TRY
BEGIN
	SET NOCOUNT ON;
	DECLARE @RS_CD_EMP				    INT
	DECLARE @RS_CD_FILIAL			    INT 		
	DECLARE @RS_DT_MOV				    DATETIME					
	DECLARE @RS_VLR_DINHEIRO			MONEY	
	DECLARE @RS_VLR_DINH			    MONEY
	DECLARE @RS_VLR_DESP			    MONEY
	DECLARE @RS_VLR_LEITURA_Z		    MONEY	
	DECLARE @RS_VLR_DEV_VD			    MONEY	
	DECLARE @RS_VLR_CONV_SEM_CAD		MONEY
	DECLARE @RS_VLR_CONSOLIDADO		    MONEY	
    DECLARE @RS_VLR_DINHEIRO_REMETIDO	MONEY	
	DECLARE @RS_VLR_DIF_LEITURA_Z		MONEY
	DECLARE @RS_VLR_DIF_LEITURA_CX	    MONEY
	DECLARE @HIST					    VARCHAR(200)
	DECLARE @NR_CONTROLE			    VARCHAR (12)
    DECLARE @TIPO 						INT;
	
	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR
	
	DECLARE RS_RESULT
	CURSOR FOR 	
		SELECT
			   1               AS CD_EMP,
			   CD_FILIAL,
			   DT_MOV,
			   SUM(VLR_DINHEIRO)     AS VLR_DINHEIRO,
			   SUM(VLR_DINH)         AS VLR_DINH,
			   SUM(VLR_DESP)         AS VLR_DESP,
			   SUM(VLR_LEITURA_Z)    AS VLR_LEITURA_Z,
			   SUM(VLR_DEV_VD)       AS VLR_DEV_VD,
			   SUM(VLR_CONV_SEM_CAD) AS VLR_CONV_SEM_CAD,
			   SUM(VLR_CONSOLIDADO)  AS VLR_CONSOLIDADO
	 FROM UFD_EXP_CTB_MOV_CAIXA(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM)
		 -- FROM UFD_EXP_CTB_MOV_CAIXA(1, 29, '20200212', '20200212')
		 GROUP BY CD_FILIAL,
				  DT_MOV
		 ORDER BY CD_FILIAL,
			      DT_MOV
		
		 
		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
					                  @RS_CD_EMP,
					                  @RS_CD_FILIAL,
					                  @RS_DT_MOV,
					                  @RS_VLR_DINHEIRO,
					                  @RS_VLR_DINH,
					                  @RS_VLR_DESP,
					                  @RS_VLR_LEITURA_Z,
					                  @RS_VLR_DEV_VD,
					                  @RS_VLR_CONV_SEM_CAD,
					                  @RS_VLR_CONSOLIDADO					
					 

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	
			
			print 'P_EXP_CTB_EXP_MOV - SELECT 1 '+CONVERT(VARCHAR, GETDATE(), 108);
			SET @TIPO =(SELECT DBO.UFD_BUSCA_PARAM_SISTEMA (1, 'FLAG_TRANSF_VLR_TES', 0, 0) );

			SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) + 
			                   RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
			                   RIGHT('00'+ CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
			                   RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '120'  -- 12 Movimento 0 - registro

			 SET @RS_VLR_DINH = @RS_VLR_DINH - (@RS_VLR_DESP + @RS_VLR_CONV_SEM_CAD)			
		
			If (@RS_VLR_DINHEIRO <> @RS_VLR_DINH) Or (@RS_VLR_CONSOLIDADO <> @RS_VLR_LEITURA_Z) 
	        
				SET @RS_VLR_DIF_LEITURA_Z 	= ROUND((@RS_VLR_LEITURA_Z - @RS_VLR_CONSOLIDADO) * -1 , 2)
	       
			    SET @RS_VLR_DIF_LEITURA_CX 	= ROUND((@RS_VLR_DINHEIRO - @RS_VLR_DINH) + @RS_VLR_DIF_LEITURA_Z, 2)							
			

				IF @RS_VLR_DINHEIRO > 0 				
					BEGIN        
						
						SET @HIST = 'VALOR REF. DIFERENCA CAIXA APURADO EM: ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 103)
						
						IF @RS_VLR_LEITURA_Z <> @RS_VLR_CONSOLIDADO 
							BEGIN 
								IF @RS_VLR_DINHEIRO <> @RS_VLR_DINH 
									BEGIN 
										SET @HIST = @HIST + ' (DIF. DIN REMETIDO X CALCULADO + DIF. GESTO X DOCS)'
									END
								ELSE
									BEGIN
										SET @HIST = @HIST + ' (GESTO X DOCUMENTOS)'
									END											           
							END
						SET @HIST = REPLACE (@HIST,'	',' ')
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa / Ctb_Cnt_Ajuste_Caixa
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  
						
					   					  (CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT		@RS_CD_EMP									AS CD_EMP,
										@CD_FILIAL									AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										12											AS CD_MOVIMENTO,
										'DIFERENCA DE CAIXA'							AS MOVIMENTO,
										''											AS OPERACAO,
										'AJUSTE - DEBITO'								AS OPERACAO_DEBITO,
										0											AS CD_CNT_RED_CREDITO,
										''											AS CD_CNT_CREDITO,
										0											AS CD_CNT_RED_DEBITO,
										''											AS CD_CNT_DEBITO,
										(CASE WHEN @TIPO = 0 THEN DATEADD(DAY, 1, @RS_DT_MOV)
										      ELSE @RS_DT_MOV
										  END)									    AS DT_MOV,
										@HIST 										AS HIST,								
										ABS(@RS_VLR_DIF_LEITURA_CX)					AS VLR_LANC,
										'D'											AS TP_TRANSA,
										0											AS RATEIO_CENTRO_CUSTO,
										''											AS DS_CENTRO_CUSTO,
										0											AS CNT_CENTRO_CUSTO,
										0											AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										(CASE WHEN @RS_VLR_DIF_LEITURA_CX < 0 THEN 25 
										      ELSE 0 
										  END)										    AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE
										  , 'X' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , ''  AS CD_BC_LANC;
							
					
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa / Ctb_Cnt_Dif_Movimento_Sistema_Maior
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  
						
					   					  (CD_EMP, CD_FILIAL_EXPORT,CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										12												AS CD_MOVIMENTO,
										'DIFERENCA DE CAIXA'							AS MOVIMENTO,
										'AJUSTE - CREDITO'								AS OPERACAO,
										''												AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										(CASE WHEN @TIPO = 0 THEN DATEADD(DAY, 1, @RS_DT_MOV)
										      ELSE @RS_DT_MOV
										  END)									        AS DT_MOV,
										@HIST 											AS HIST,								
										ABS(@RS_VLR_DIF_LEITURA_CX)						AS VLR_LANC,
										'C'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										(CASE WHEN @RS_VLR_DIF_LEITURA_CX < 0 THEN 0 ELSE 10 END) AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE										
										  , 'X' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , ''  AS CD_BC_LANC;
					END

				------------------------------------------------------------------------------------------------------------------
				--Prximo registro				
				------------------------------------------------------------------------------------------------------------------
				--Atribuindo valores do select nas variveis
				FETCH NEXT FROM RS_RESULT INTO 
											  @RS_CD_EMP,
											  @RS_CD_FILIAL,
											  @RS_DT_MOV,
											  @RS_VLR_DINHEIRO,
											  @RS_VLR_DINH,
											  @RS_VLR_DESP,
											  @RS_VLR_LEITURA_Z,
											  @RS_VLR_DEV_VD,
											  @RS_VLR_CONV_SEM_CAD,
											  @RS_VLR_CONSOLIDADO																

			END
		
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
END

END TRY
BEGIN CATCH
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					
  